/*
 * Decompiled with CFR 0.152.
 */
public abstract class BlockGrowingPlant
extends BlockPlant {
    public BlockGrowingPlant(int block_id) {
        super(block_id);
        this.setMaxStackSize(8);
    }

    public abstract float getLowestOptimalTemperature();

    public abstract float getHighestOptimalTemperature();

    public float getTemperatureTolerance() {
        return 1.0f;
    }

    public float getGlobalGrowthRateModifierFromMITE() {
        return 0.25f;
    }

    public float getTemperatureGrowthRateModifier(float temperature) {
        float delta_temp;
        if (temperature < this.getLowestOptimalTemperature()) {
            delta_temp = this.getLowestOptimalTemperature() - temperature;
        } else if (temperature > this.getHighestOptimalTemperature()) {
            delta_temp = temperature - this.getHighestOptimalTemperature();
        } else {
            return 1.0f;
        }
        return Math.max(1.0f - delta_temp / this.getTemperatureTolerance(), 0.0f);
    }

    public abstract float getHumidityGrowthRateModifier(boolean var1);

    public float getProximityGrowthRateModifier(abw world, int x2, int y2, int z2) {
        boolean north = world.getBlock(x2, y2, z2 - 1) == this;
        boolean east = world.getBlock(x2 + 1, y2, z2) == this;
        boolean south = world.getBlock(x2, y2, z2 + 1) == this;
        boolean west = world.getBlock(x2 - 1, y2, z2) == this;
        int num_neighbors = 0;
        if (north) {
            ++num_neighbors;
        }
        if (east) {
            ++num_neighbors;
        }
        if (south) {
            ++num_neighbors;
        }
        if (west) {
            ++num_neighbors;
        }
        if (num_neighbors > 1) {
            return 1.0f;
        }
        float isolation_penalty_factor = 0.5f;
        if (num_neighbors == 0) {
            return 0.5f;
        }
        if (north && (world.getBlock(x2, y2, z2 - 2) == this || world.getBlock(x2 + 1, y2, z2 - 1) == this || world.getBlock(x2 - 1, y2, z2 - 1) == this)) {
            return 1.0f;
        }
        if (east && (world.getBlock(x2 + 1, y2, z2 - 1) == this || world.getBlock(x2 + 2, y2, z2) == this || world.getBlock(x2 + 1, y2, z2 + 1) == this)) {
            return 1.0f;
        }
        if (south && (world.getBlock(x2 + 1, y2, z2 + 1) == this || world.getBlock(x2, y2, z2 + 2) == this || world.getBlock(x2 - 1, y2, z2 + 1) == this)) {
            return 1.0f;
        }
        if (west && (world.getBlock(x2 - 1, y2, z2 - 1) == this || world.getBlock(x2 - 1, y2, z2 + 1) == this || world.getBlock(x2 - 2, y2, z2) == this)) {
            return 1.0f;
        }
        return 0.75f;
    }

    public int getMinAllowedLightValueForGrowth() {
        return 15;
    }

    public int getMaxAllowedLightValueForGrowth() {
        return 15;
    }

    public boolean isLightLevelSuitableForGrowth(int block_light_value) {
        return block_light_value >= this.getMinAllowedLightValueForGrowth() && block_light_value <= this.getMaxAllowedLightValueForGrowth();
    }

    public abstract float getGrowthRate(abw var1, int var2, int var3, int var4);
}

